/* -----------------------------
URLS
----------------------------- */
var conf_url_base = 'http://www.ultraedit.com/redirects/registration/';

/* -----------------------------
Conditional strings
----------------------------- */


// Progress bar text
var conf_days_left = '<span class="l_trialDaysText">Days left in free trial:</span> ';
var conf_no_days_left = '<span class="l_noTrialDaysText">Please purchase a license to continue using <span class="appname"></span>.</span>';

// Title: In trial mode
var conf_title_trial_mode = hereDoc(function() {/*!
          <span id="trialText" class="l_trialModeText">
            <span class="appname"></span> is running in trial mode.
          </span>
*/});

// Title: Trial is expiring
var conf_title_trial_expiring = hereDoc(function() {/*!
          <span id="trialText" class="l_trialExpiring">
            Your free trial is expiring.
          </span>
*/});

// Title: Trial about to expire
var conf_title_almost_expired = hereDoc(function() {/*!
          <span id="trialExpiredText" class="l_trialAlmostExpiredText">
            Your free trial has almost expired.
          </span>
*/});

// Title: Trial expired
var conf_title_trial_expired = hereDoc(function() {/*!
          <span id="trialExpiredText" class="l_trialExpiredText">
            Your free trial has expired.
          </span>
*/});




/* -----------------------------
Dynamic content blocks
----------------------------- */

// UC content block
var conf_content_uc = hereDoc(function() {/*!
      <div id="ipm-content-inner">

        <!-- box shot / multi-platform-->
        <div class="left-col-box">
          <img src="images/box-uc.png" alt="" style="margin-bottom: 12px;" class="appbox">
          <img src="images/multi-platform.png" alt="">
        </div>

        <!-- benefits text -->
        <div class="right-col-benefits">

          <p>
            <span class="l_bftHead">
              Your personal license includes:
            </span>
          </p>

          <div class="benefits-list">

            <img src="images/check.png" alt="*">
            <span class="l_bftMultiPlatform">
              The <strong>Windows</strong>, <strong>Mac</strong>, and <strong>Linux</strong> versions
            </span>
            <br>

            <img src="images/check.png" alt="*">
            <span class="l_bftThreeInstalls">
              Installation on up to 3 machines
            </span>
            <br>

            <img src="images/check.png" alt="*">
            <span class="l_bftFreeUpgrades">
              Free upgrades for a year
            </span>
            <br>

            <img src="images/check.png" alt="*">
            <span class="l_bftTechSupport">
              Unlimited lifetime tech support
            </span>

          </div>

          <p>
            <span class="l_worldsBest">
              <span class="appname"></span>: The world&#39;s #1 text editor.<br>
              Preferred by millions!
            </span>
          </p>

        </div>

      </div>
*/});

// UE/UC promo content block
var conf_content_ueuc = hereDoc(function() {/*!
      <div class="darkbg">
        <div id="ipm-content-inner" class="darkbg">

          <h2 class="attention">
            <span class="l_bundleHeadline">
            </span>
          </h2>

          <div class="left-col-box" styl>

            <img src="images/box-ueuc.png" alt="" style="margin: 12px 0 8px 0;" class="bdlbox"><br>

            <div class="prices">

              <span class="l_ueucPriceRetailText">
                Retail:
              </span>
              <span class="price pnewBdlR l_ueucPriceRetailAmt">
              </span>

              <br>

              <span class="l_ueucPriceText">
                You pay:
              </span>
              <span class="price pnewBdl l_ueucPriceAmt">
              </span>

            </div>

            <img src="images/multi-platform.png" alt="" style="margin-top: 12px;">

          </div>

          <ul class="benefitList">

            <li>&bull;
              <span class="l_ueucBft1">
                Integrated with <span class="bdlabbr"></span>
              </span>
            </li>

            <li>&bull;
              <span class="l_ueucBft2">
                Integrate with version control
              </span>
            </li>

            <li>&bull;
              <span class="l_ueucBft3">
                Diff up to 3 files/folders
              </span>
            </li>

            <li>&bull;
              <span class="l_ueucBft4">
                Compare Word docs, PDFs
              </span>
            </li>

            <li>&bull;
              <span class="l_ueucBft5">
                Sync local to FTP
              </span>
            </li>

            <li>&bull;
              <span class="l_ueucBft6">
                Compare & preview HTML
              </span>
            </li>

            <li>&bull;
              <span class="l_ueucBft7">
                Merge differences
              </span>
            </li>

            <li>&bull;
              <span class="l_ueucBft8">
                Save compare sessions
              </span>
            </li>

          </ul>

          <div class="savingsText">
            <span class="l_ueucSavingsPercent">
              Save 50%
            </span>
            <br>
            <span class="l_ueucSavingsText">
              on <span class="appabbr"></span> when you bundle it with <span class="bdlabbr"></span>!
            </span>
          </div>

          <!-- Buy new button -->
          <a href="#" id="buynewBdl" target="_blank" class="button">
            <span class="l_buyueucNew" style="font-size: 85%;">
              Buy <span class="bdlabbr"></span>/<span class="appabbr"></span> new:
            </span>
            <strong>
              <span class="price pnewBdl l_ueucPriceAmt" style="color: #000000;">
              </span>
            </strong>
          </a>

          <!-- Upgrade button -->
          <a href="#" id="buyupg2Bdl" target="_blank" class="button">
            <span class="l_upgradeueuc" style="font-size: 85%;">
              Upgrade <span class="bdlabbr"></span>, add <span class="appabbr"></span>:
            </span>
            <strong>
              <span class="price pupg2Bdl l_upgradeueucPrice">
              </span>
            </strong>
          </a>

        </div>
      </div>
*/});

var conf_content_f_compare_folders = hereDoc(function() {/*!
     <div class="darkbg">

      <img src="images/feat-folder-mode.png" class="feat-img">

      <h3 class="feature">
       <span class="l_f_CompareFoldersHead">
        Compare your folders, .zip archives, and more with Folder Mode
       </span>
      </h3>

      <p class="feat-desc">
       <span class="l_f_CompareFolders">
        Use Folder mode to quickly compare local, network, or remote directories (using the built-in FTP/SFTP support).
        <br>
        <br>
        Deep directory structures?  No problem... Folder mode is performance optimized for large directory structures allowing you to start working with the top-level folders while <span class="appname"></span> continues to process the subdirectories in the background.
       </span>
        <br>
        <br>
       <a href="http://www.ultraedit.com/support/tutorials_power_tips/ultracompare/recursive_compare.html" target="_blank">
        <span class="l_learnMore">
         Click to learn more
        </span>
       </a>
      </p>

     </div>
*/});

var conf_content_f_sync_folders = hereDoc(function() {/*!
     <div class="darkbg">

      <img src="images/feat-folder-sync.png" class="feat-img" style="margin-left: 18px; margin-top: 24px; margin-right: 18px;">

      <h3 class="feature">
       <span class="l_f_SyncFoldersHead">
        Sync folders in a single click
       </span>
      </h3>

      <p class="feat-desc">
       <span class="l_f_SyncFolders">
        You can synchronize two folders easily using <span class="appname"></span>, whether the folders are local, network, or from an FTP server!  To run folder sync, check the "Sync folders" option near the bottom of a folder compare.
        <br>
        <br>
        Here you can also set and customize sync rules.  If you have any files you don't want changed by the sync, you can manually override sync actions for the files in the folder compare pane.
       </span>
        <br>
        <br>
       <a href="http://www.ultraedit.com/support/tutorials_power_tips/ultracompare/sync-folders.html" target="_blank">
        <span class="l_learnMore">
         Click to learn more
        </span>
       </a>
      </p>

     </div>
*/});

var conf_content_f_compare_text = hereDoc(function() {/*!
     <div class="darkbg">

      <img src="images/feat-compare-text.png" class="feat-img" style="margin-bottom: 0;">

      <h3 class="feature">
       <span class="l_f_CompareTextHead">
        Compare text, source code, Word Docs
       </span>
      </h3>

      <p class="feat-desc">
       <span class="l_f_CompareText">
        <span class="appname"></span> supports 2 and 3 way comparison - great for version control, validating backups, and tracking your team\'s modifications. The relational lines visually link differences between files so you can easily identify and merge differences between your files.
        <br>
        <br>
        <span class="appname"></span> also higlights the individual character differences within the text making visual inspection of your file differences even faster.
       </span>
      </p>

     </div>
*/});

var conf_content_f_merge = hereDoc(function() {/*!
     <div class="darkbg">

      <img src="images/feat-merge.png" class="feat-img">

      <h3 class="feature">
       <span class="l_f_MergeHead">
        Merge differences with block and line mode merge
       </span>
      </h3>

      <p class="feat-desc">
       <span class="l_f_Merge">
        <span class="appname"></span> features powerful merge options that give you total control over the differences between your compared files.
        <br>
        <br>
        <span class="appname"></span> will save you hours with its powerful and intuitive merge features.  You can merge differences using the merge toolbar, the merge icons between compare panes, or by using the Merge menu options.
       </span>
       <br>
       <br>
       <a href="http://www.ultraedit.com/support/tutorials_power_tips/ultracompare/block_line_mode_merge.html" target="_blank">
        <span class="l_learnMore">
         Click to learn more
        </span>
       </a>
      </p>

     </div>
*/});

var conf_content_f_shell_integration = hereDoc(function() {/*!
     <div class="darkbg">

      <img src="images/feat-shell-integration.png" class="feat-img">

      <h3 class="feature">
       <span class="l_f_ShellIntegrationHead">
        Quickly execute your file and folder compare operations from the right-click menu in Windows Explorer
       </span>
      </h3>

      <p class="feat-desc">
       <span class="l_f_ShellIntegration">
        If you're constantly comparing files and directories, you need something that is fast, efficient, and easy to use. <span class="appname"></span> streamlines your compare operations by direcly integrating with Windows Explorer through Shell Integration.
        <br>
        <br>
        Shell integration allows you to mark files in Windows Explorer then run your compare - all from the convenient right-click menu.
       </span>
       <br>
       <br>
       <a href="http://www.ultraedit.com/support/tutorials_power_tips/ultracompare/ultracompare_shell_integration.html" target="_blank">
        <span class="l_learnMore">
         Click to learn more
        </span>
       </a>
      </p>
      
     </div>
*/});

var conf_content_f_text_snippets = hereDoc(function() {/*!
     <div class="darkbg">

      <img src="images/feat-text-snippets.png" class="feat-img">

      <h3 class="feature">
       <span class="l_f_TextSnippetsHead">
        Compare text snippets without having to open/save files
       </span>
      </h3>

      <p class="feat-desc">
       <span class="l_f_TextSnippets">
        Simply copy/paste your text directly into the compare frame!
        <br>
        <br>You can copy and paste text from a variety of sources including emails, Word Documents, webpages, and more. You'll love the text snippet compare, it will greatly enhance the efficiency of your text compare operations.
       </span>
       <br>
       <br>
       <a href="http://www.ultraedit.com/support/tutorials_power_tips/ultracompare/compare_code_snippets.html" target="_blank">
        <span class="l_learnMore">
         Click to learn more
        </span>
       </a>
      </p>
      
     </div>
*/});

var conf_content_f_ftp = hereDoc(function() {/*!
     <div class="darkbg">

      <img src="images/feat-ftp.png" class="feat-img" style="margin-bottom: 0;">

      <h3 class="feature">
       <span class="l_f_FTPHead">
        Compare and sync remote files and folders with integrated FTP/SFTP support
       </span>
      </h3>

      <p class="feat-desc">
       <span class="l_f_FTP">
        <span class="appname"></span>'s FTP/SFTP directory compare allows you to access remote files and folders located on a server. Execute a directory compare and sync your remote files and directories with your local copies. Compare, merge, and save... it's that easy!
       </span>
       <br>
       <br>
       <a href="http://www.ultraedit.com/support/tutorials_power_tips/ultracompare/compare_ftp_directories.html" target="_blank">
        <span class="l_learnMore">
         Click to learn more
        </span>
       </a>
      </p>
      
     </div>
*/});

var conf_content_f_sessions = hereDoc(function() {/*!
     <div class="darkbg">

      <img src="images/feat-sessions.png" class="feat-img" style="margin-bottom: 0;">

      <h3 class="feature">
       <span class="l_f_SessionsHead">
        Manage multiple compare sets with Sessions
       </span>
      </h3>

      <p class="feat-desc">
       <span class="l_f_Sessions">
        Opening multiple instances of any application makes it harder to work, so <span class="appname"></span> gives you <strong>sessions</strong> to simplify your compare operations!
        <br>
        <br>
        Sessions allow you to work with multiple compare sets &ndash; regardless of mode &ndash; all within one application. The tabbed interface allows you to easily toggle between multiple sessions for easier and more intuitive compare operations.
       </span>
       <br>
       <br>
       <a href="http://www.ultraedit.com/support/tutorials_power_tips/ultracompare/ultracompare_sessions.html" target="_blank">
        <span class="l_learnMore">
         Click to learn more
        </span>
       </a>
      </p>
      
     </div>
*/});

var conf_content_f_compare_archives = hereDoc(function() {/*!
     <div class="darkbg">

      <img src="images/feat-compare-archives.png" class="feat-img">

      <h3 class="feature">
       <span class="l_f_CompareArchivesHead">
        Compare .zip, .jar, and .rar archives
       </span>
      </h3>

      <p class="feat-desc">
       <span class="l_f_CompareArchives">
        Got archives? <span class="appname"></span>'s archive compare allows you to compare the contents of .zip, .rar, and Java .jar archives.
        <br>
        <br>
        Use the archive compare and examine differences between archives or folders on the file system. And best of all... the archive compare feature is easy-to-use!
       </span>
      </p>
      
     </div>
*/});

var conf_content_f_doc_pdf = hereDoc(function() {/*!
     <div class="darkbg">

      <img src="images/feat-doc-pdf.png" class="feat-img">

      <h3 class="feature">
       <span class="l_f_DocPDFHead">
        Compare Word, RTF, and PDF files in a snap!
       </span>
      </h3>

      <p class="feat-desc">
       <span class="l_f_DocPDF">
        <span class="appname"></span> supports compare and merge operations for Microsoft Word Documents, RTF files, and PDF documents.
        <br>
        <br>
        If you need to see what's been changed on your contracts, papers, and more... then <span class="appname"></span>'s Word Doc compare is what you're looking for!
       </span>
      </p>
      
     </div>
*/});

var conf_content_f_version_control = hereDoc(function() {/*!
     <div class="darkbg">

      <img src="images/feat-version-control.png" class="feat-img">

      <h3 class="feature">
       <span class="l_f_VersionControlHead">
        Use <span class="appname"></span> to diff and merge from Git, Subversion, CVS, and more
       </span>
      </h3>

      <p class="feat-desc">
       <span class="l_f_VersionControl">
        You can use <span class="appname"></span> as your diff or merge tool for your preferred version control system &ndash; Git, Subversion, CVS, Perforce and many other popular version control systems!
        <br>
        <br>
        <span class="appname"></span> includes the command line functionality required for these systems.  With a minor tweak to your system's configuration, you can diff and merge files in <span class="appname"></span> directly from your version control.
       </span>
       <br>
       <br>
       <a href="http://www.ultraedit.com/support/tutorials_power_tips/ultracompare/version-control-comparison.html" target="_blank">
        <span class="l_learnMore">
         Click to learn more
        </span>
       </a>
      </p>
      
     </div>
*/});

var conf_content_f_command_line_quick_diff = hereDoc(function() {/*!
     <div class="darkbg">

      <img src="images/feat-quick-diff.png" class="feat-img">

      <h3 class="feature">
       <span class="l_f_QuickDiffHead">
        Perform a command line quick diff to compare your files without launching <span class="appname"></span>
       </span>
      </h3>

      <p class="feat-desc">
       <span class="l_f_QuickDiff">
        The Quick Difference checks your files to see if they are different without showing the GUI &ndash; making the compare ultra-fast. 
        <br>
        <br>
        If you need to quickly check whether your files are different, without needing to see where the differences are, then this is one command you want in your arsenal.
       </span>
       <br>
       <br>
       <a href="http://www.ultraedit.com/support/tutorials_power_tips/ultracompare/quick_diff_check.html" target="_blank">
        <span class="l_learnMore">
         Click to learn more
        </span>
       </a>
      </p>
      
     </div>
*/});

var conf_content_f_inline_editing = hereDoc(function() {/*!
     <div class="darkbg">

      <img src="images/feat-inline-edit.png" class="feat-img" style="margin-bottom: 0;">

      <h3 class="feature">
       <span class="l_f_InlineEditingHead">
        Edit text directly in the compare panes
       </span>
      </h3>

      <p class="feat-desc">
       <span class="l_f_InlineEditing">
        While you can edit your files in <span class="bdlname"></span> and merge differences in <span class="appname"></span>, sometimes you need to make a quick change to the file directly in the compare frame. Editing text on the fly is essential in a text compare app.
        <br>
        <br>
        <span class="appname"></span> offers two ways to directly edit your files: editing directly in the compare panes or double clicking to edit in the active line window at the bottom of the application.
       </span>
      </p>
      
     </div>
*/});

var conf_content_f_text_ignore_options = hereDoc(function() {/*!
     <div class="darkbg">

      <img src="images/feat-ignore-options.png" class="feat-img">

      <h3 class="feature">
       <span class="l_f_IgnoreOptionsHead">
        Only compare what's important by using ignore options
       </span>
      </h3>

      <p class="feat-desc">
       <span class="l_f_IgnoreOptions">
        Want to ignore differences in comments when comparing source files?  Need to ignore a specific number of lines at the beginning or end of the file?  Want to ignore differences in spaces, tabs, or line endings? Ignore options make this all possible.  To set ignore options for your compare, go to <strong>Session</strong> -> <strong>Session Properties</strong>, make the changes you want, then click <strong>OK and Run</strong>.
       </span>
       <br>
       <br>
       <a href="http://www.ultraedit.com/support/tutorials_power_tips/ultracompare/ignore_options.html" target="_blank">
        <span class="l_learnMore">
         Click to learn more
        </span>
       </a>
      </p>
      
     </div>
*/});

var conf_content_html_preview = hereDoc(function() {/*!
     <div class="darkbg">

      <img src="images/feat-html.png" class="feat-img" style="margin-bottom: 0;">

      <h3 class="feature">
       <span class="l_f_HTMLHead">
        Inspect your code with HTML preview
       </span>
      </h3>

      <p class="feat-desc">
       <img src="images/feat-html-icon.png" class="img-left" >
       <span class="l_f_HTML">
        If you compare/merge HTML files and need to see what the changes look like in the browser, then you've come to the right place!
        <br>
        <br>
        <span class="appname"></span> supports an integrated browser view in the compare panes that allows you to preview the HTML rendered as you would see it in your web browser. Simply compare, merge and/or edit, then hit the browser view for a quick visual inspection of your changes.
       </span>
       <br>
       <br>
       <a href="http://www.ultraedit.com/support/tutorials_power_tips/ultracompare/visually_inspect_html.html" target="_blank">
        <span class="l_learnMore">
         Click to learn more
        </span>
       </a>
      </p>
      
     </div>
*/});


// Object with each day and what its content will be.
conf_day_content = {
   d : conf_content_uc,  // Default
  30 : conf_content_uc,
  29 : conf_content_f_compare_folders,
  28 : conf_content_f_sync_folders,
  27 : conf_content_f_doc_pdf,
  26 : conf_content_uc,
  25 : conf_content_uc,
  24 : conf_content_f_compare_archives,
  23 : conf_content_f_shell_integration,
  22 : conf_content_uc,
  21 : conf_content_uc,
  20 : conf_content_f_version_control,
  19 : conf_content_f_ftp,
  18 : conf_content_f_sessions,
  17 : conf_content_uc,
  16 : conf_content_uc,
  15 : conf_content_f_compare_text,
  14 : conf_content_f_merge,
  13 : conf_content_f_text_snippets,
  12 : conf_content_uc,
  11 : conf_content_uc,
  10 : conf_content_f_command_line_quick_diff,
   9 : conf_content_f_inline_editing,
   8 : conf_content_f_text_ignore_options,
   7 : conf_content_html_preview,
   6 : conf_content_uc,
   5 : conf_content_uc,
   4 : conf_content_uc,
   3 : conf_content_uc,
   2 : conf_content_uc,
   1 : conf_content_uc,
   0 : conf_content_uc
};

// Object with app names and properties
conf_apps = {

  ucw : {
    appname: 'UltraCompare',
    appabbr: 'UC',
    bdlname: 'UltraEdit',
    bdlabbr: 'UE',
    os     : 'Windows',
    appbox : 'box-uc.png',
    bdlbox : 'box-ueuc.png',
    prices: {
      pnew    : '$49.95',
      pupg    : '$24.95',
      pnewBdl : '$99.95',
      pnewBdlR: '$129.95',
      pupg2Bdl: '$69.95',
    },
    urls: {
      buynew    : 'uc_register.html',
      buyupg    : 'uc_paid_upgrade.html',
      buynewBdl : 'ueuc_bundle_register.html',
      buyupg2Bdl: 'ue2ueuc_bundle_upgrade.html'
    }
  },

  ucm : {
    appname : 'UC Mobile',
    appabbr : 'UCm',
    bdlname : 'UE Mobile',
    bdlabbr : 'UEm',
    os      : 'Windows',
    appbox  : 'box-ucm.png',
    bdlbox  : 'box-uemucm.png',
    prices: {
      pnew    : '$49.95',
      pupg    : '$24.95',
      pnewBdl : '$89.95',
      pnewBdlR: '$109.95',
      pupg2Bdl: '$54.95',
    },
    urls: {
      buynew    : 'uc3_register.html',
      buyupg    : 'uc3_paid_upgrade.html',
      buynewBdl : 'ue3uc3_bundle_register.html',
      buyupg2Bdl: 'ue32ue3uc3_bundle_upgrade.html'
    }
  }

}


/* -----------------------------
Internally used functions
----------------------------- */
/* Kludgy function to facilitate multi-line strings in Javascript */
function hereDoc(f) {
  return f.toString().
  replace(/^[^\/]+\/\*!?/, '').
  replace(/\*\/[^\/]+$/, '');
}

/* IE9 doesn't support indexOf so we have to create it ourselves */
if (!Array.prototype.indexOf) {
  Array.prototype.indexOf = function (searchElement /*, fromIndex */ ) {
    'use strict';
    if (this == null) {
      throw new TypeError();
    }
    var n, k, t = Object(this),
        len = t.length >>> 0;

    if (len === 0) {
      return -1;
    }
    n = 0;
    if (arguments.length > 1) {
      n = Number(arguments[1]);
      if (n != n) { // shortcut for verifying if it's NaN
        n = 0;
      } else if (n != 0 && n != Infinity && n != -Infinity) {
        n = (n > 0 || -1) * Math.floor(Math.abs(n));
      }
    }
    if (n >= len) {
      return -1;
    }
    for (k = n >= 0 ? n : Math.max(len - Math.abs(n), 0); k < len; k++) {
      if (k in t && t[k] === searchElement) {
        return k;
      }
    }
    return -1;
  };
}

// Gets URL parameters
function getParam(name) {
  return decodeURIComponent((new RegExp('[?|&]' + name + '=' + '([^&;]+?)(&|#|;|$)').exec(location.search)||[,""])[1].replace(/\+/g, '%20'))||null
}

// replace the innerHTML of an element (targeted by ID)
function replaceInnerHTML(replaceID, replaceWith) {
  var e = document.getElementById(replaceID);
  if (e) e.innerHTML = replaceWith; 
}